% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00_mfd.R
\name{cor_mfd}
\alias{cor_mfd}
\title{Correlation Function for Multivariate Functional Data}
\usage{
cor_mfd(mfdobj1, mfdobj2 = mfdobj1)
}
\arguments{
\item{mfdobj1}{An object of class \code{mfd} representing the first multivariate functional data set.
It contains \eqn{N} observations of a \eqn{p}-dimensional multivariate functional variable.}

\item{mfdobj2}{An object of class \code{mfd} representing the second multivariate functional data set.
Defaults to \code{mfdobj1}. If provided, it must also contain \eqn{N} observations of a \eqn{p}-dimensional
multivariate functional variable.}
}
\value{
A bifd object representing the correlation function of the two input objects. The output
is a collection of \eqn{p^2} functional surfaces, each corresponding to the correlation between
two components of the multivariate functional data.
}
\description{
Computes the correlation function for two multivariate functional data objects of class \code{mfd}.
}
\details{
The function calculates the correlation between all pairs of dimensions from the two multivariate
functional data objects. The data is first scaled using \code{\link{scale_mfd}}, and the correlation
is then computed as the covariance of the scaled data using \code{\link{cov_mfd}}.
}
\examples{
\dontrun{
library(funcharts)
data("air")
x <- get_mfd_list(air[1:3])
cor_result <- cor_mfd(x)
plot_bifd(cor_result)
}

}
