% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AMFCC.R
\name{AMFCC_PhaseI}
\alias{AMFCC_PhaseI}
\title{Phase I of the Adaptive Multivariate Functional Control Chart (AMFCC).}
\usage{
AMFCC_PhaseI(
  data_tra,
  data_tun = NULL,
  grid,
  q = 30,
  par_seq_list = list(10^seq(-7, 2, l = 10), c(0.5, 0.7, 0.8, 0.9, 0.99)),
  alpha_diagn = 0.05,
  alpha_mon = 0.05,
  ncores = 1
)
}
\arguments{
\item{data_tra}{a data frame with the training data with the following columns:
\itemize{
\item var: vector of the variable indexes.
\item curve: vector of the curve indexes.
\item timeindex: vector of the time indexes corresponding to
given elements of \code{grid}.
\item x: concatenated vector of the observed curves.
}}

\item{data_tun}{a data frame with the tuning data with the same structure as \code{data_tra}.
If NULL, \code{data_tun} is set to \code{data_tra}.}

\item{grid}{The vector of time points where the curves are sampled.}

\item{q}{The dimension of the set of B-spline functions.}

\item{par_seq_list}{a list with two elements.
The first element is a sequence of values for the regularization
parameter \eqn{\lambda} and the second element is a sequence of
percentages of the total variability  to select \eqn{L}.}

\item{alpha_diagn}{Type I error probability for the diagnostic.}

\item{alpha_mon}{Type I error probability for the monitoring.}

\item{ncores}{number of cores to use for parallel computing}
}
\value{
A list containing the following arguments:
\itemize{
\item \code{statistics_IC}: A matrix with the values of the Hotelling T^2-type
statistics for each observation and parameter combination.
\item \code{p_values_combined}: A list with two elements containing the
monitoring statistics obtained with the Fisher omnibus and Tippett combining
functions.
\item \code{CL}: The control limits for the monitoring statistics obtained with
the Fisher omnibus and Tippett combining functions.
\item \code{contributions_IC}: A list where each element corresponds to a variable
and is a matrix with the contributions to the Hotelling \eqn{T^2}-type
statistics for each observation and parameter combination.
\item \code{p_values_combined_cont}: A list where each element corresponds to a
variable and is a list of two elements containing the contribution to the
monitoring statistics obtained with the Fisher omnibus and Tippett
combining functions.
\item \code{CL_cont}: The control limits for the contribution to the monitoring
statistics obtained with the Fisher omnibus and Tippett combining functions.
\item \code{par_seq_list}: The list of the sequences of the tuning parameters.
\item \code{q}: The dimension of the set of B-spline functions.
\item \code{basis}: The basis functions used for the functional data representation.
\item \code{grid}: The vector of time points where the curves are sampled.
\item \code{comb_list_tot}: The matrix with all the parameter combinations.
\item \code{mod_pca_list}: The list of the MFPCA models for each value of
\code{lambda_s}.
}
}
\description{
This function implements the design phase (Phase I) of the
Adaptive Multivariate Functional Control Chart.
}
\examples{
library(funcharts)
N <- 10
l_grid <- 10
p <- 2
grid <- seq(0, 1, l = l_grid)


Xall_tra <- funcharts::simulate_mfd(
  nobs = N,
  p = p,
  ngrid = l_grid,
  correlation_type_x = c("Bessel", "Gaussian")
)
X_tra <-
  data.frame(
    x = c(Xall_tra$X_list[[1]], Xall_tra$X_list[[2]]),
    timeindex = rep(rep(1:l_grid, each = (N)), p),
    curve = rep(1:(N), l_grid * p),
    var = rep(1:p, each = l_grid * N)
  )

Xall_II <- funcharts::simulate_mfd(
  nobs = N,
  p = p,
  ngrid = l_grid,
  shift_type_x = list("A", "B"),
  d_x = c(10, 10),
  correlation_type_x = c("Bessel", "Gaussian")
)

X_II <-
  data.frame(
    x = c(Xall_II$X_list[[1]], Xall_II$X_list[[2]]),
    timeindex = rep(rep(1:l_grid, each = (N)), p),
    curve = rep(1:(N), l_grid * p),
    var = rep(1:p, each = l_grid * N)
  )

# AMFCC -------------------------------------------------------------------
print("AMFCC")

mod_phaseI_AMFCC <- AMFCC_PhaseI(
  data_tra = X_tra,
  data_tun =
    NULL,
  grid = grid,
  ncores = 1
)

mod_phaseII_AMFCC <- AMFCC_PhaseII(data = X_II,
mod_Phase_I = mod_phaseI_AMFCC,
ncores = 1)

plot(mod_phaseII_AMFCC)
plot(mod_phaseII_AMFCC,type='cont',ind_obs=1)

}
\references{
Centofanti, F., A. Lepore, and B. Palumbo (2025).
An Adaptive Multivariate Functional Control Chart.
Accepted for publication in \emph{Technometrics}.
}
\author{
F. Centofanti
}
