% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cross_plot.R
\name{equal_freq}
\alias{equal_freq}
\title{Equal frequency binning}
\usage{
equal_freq(var, n_bins)
}
\arguments{
\item{var}{input variable}

\item{n_bins}{number of bins to split 'var' by equal frequency, if it not possible to calculate for the desired bins, it returns the closest number}
}
\value{
The binned variable.
}
\description{
Equal frequency tries to put the same quantity of cases per bin when possible. It's a wrapper of function cut2 from Hmisc package.
}
\examples{
## Example 1
summary(heart_disease$age)
age_2=equal_freq(var=heart_disease$age, n_bins = 10)
summary(age_2)

## Example 2
age_3=equal_freq(var=heart_disease$age, n_bins = 5)
summary(age_3)
}
