% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roc_plot.R
\name{roc_plot}
\alias{roc_plot}
\title{A function to plot ROC curves.}
\usage{
roc_plot(cp, ca, group = NULL, byDR = FALSE, grayscale = FALSE, ...)
}
\arguments{
\item{cp}{A vector of cp id rates or frequencies.}

\item{ca}{A vector of ca id rates or frequencies.}

\item{group}{Grouping variable to indicate group membership. Will create an ROC curve and calculate AUC for each group.}

\item{byDR}{Whether to order ids by diagnosticity ratios. Defaults to FALSE.}

\item{grayscale}{Whether to produce the plot in grayscale. Defaults to FALSE.}

\item{...}{Additional plotting parameters.
For example, users can change x-axis and y-axis labels using \code{xlab} and \code{ylab}.}
}
\value{
Plot ROC curves and calculate AUCs as side effects.
}
\description{
A function to plot ROC curves.
}
\examples{
cpf1 <- c(100, 90, 80, 20, 10, 5)
caf1 <- c(6, 7, 15, 50, 75, 120)
roc_plot(cpf1, caf1)


cpf2 <- c(90, 40, 20)
caf2 <- c(10, 70, 80)
roc_plot(cpf2, caf2)

## plot two ROC curves
cpf <- c(cpf1, cpf2)
caf <- c(caf1, caf2)
group <- rep(letters[1:2], times = c(length(cpf1), length(cpf2) ) )
roc_plot(cpf, caf, group = group)

}
\references{
Yueran Yang & Andrew Smith. (2020). "fullROC: An R package for generating and analyzing eyewitness-lineup ROC curves"
\doi{10.13140/RG.2.2.20415.94885/1}

Andrew Smith, Yueran Yang, & Gary Wells. (2020). "Distinguishing between investigator discriminability and eyewitness discriminability: A method for creating full receiver operating characteristic curves of lineup identification performance". \emph{Perspectives on Psychological Science, 15}(3), 589-607.
\doi{10.1177/1745691620902426}
}
