% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KNN_RNA.R
\name{KNN_RNA}
\alias{KNN_RNA}
\title{K-Nearest Neighbor_RNA (KNN_RNA)}
\usage{
KNN_RNA(seqs, trainSeq, percent = 30, labeltr = c(), label = c())
}
\arguments{
\item{seqs}{is a FASTA file containing ribonucleotide sequences. The sequences start
with '>'. Also, seqs could be a string vector. Each element of the vector is a ribonucleotide sequence.}

\item{trainSeq}{is a fasta file with ribonucleotide sequences. Each sequence starts
with a '>' character. Also it could be a string vector such that each element is a ribonucleotide sequence. Eaxh sequence in the training set
is associated with a label. The label is found in the parameret labeltr.}

\item{percent}{determines the threshold which is used to identify sequences (in the training set) which are similar to the input sequence.}

\item{labeltr}{This parameter is a vector whose length is equivalent to the number of sequences in the training set. It shows class of
each sequence in the trainig set.}

\item{label}{is an optional parameter. It is a vector whose length is equivalent to the number of sequences. It shows the class of
each entry (i.e., sequence).}
}
\value{
This function returns a feature matrix such that number of columns is number of classes multiplied by percent and number of rows is equal to the number of the sequences.
}
\description{
This function is like \link{KNNPeptide} with the difference that similarity score is computed by Needleman-Wunsch algorithm.
}
\examples{

ptmSeqsADR<-system.file("extdata/",package="ftrCOOL")
posSeqs<-fa.read(file=paste0(ptmSeqsADR,"/pos2RNA51.txt"),alphabet="rna")
negSeqs<-fa.read(file=paste0(ptmSeqsADR,"/neg2RNA51.txt"),alphabet="rna")
seqs<-fa.read(file=paste0(ptmSeqsADR,"/testSeq2RNA51.txt"),alphabet="rna")


trainSeq<-c(posSeqs,negSeqs)


labelPos<-rep(1,length(posSeqs))
labelNeg<-rep(0,length(negSeqs))

labeltr<-c(labelPos,labelNeg)

KNN_RNA(seqs=seqs,trainSeq=trainSeq,percent=10,labeltr=labeltr)

}
\references{
Wei,L., Su,R., Luan,S., Liao,Z., Manavalan,B., Zou,Q. and Shi,X. Iterative feature representations improve N4-methylcytosine site prediction. Bioinformatics,  (2019).
}
