% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ASDC.R
\name{ASDC}
\alias{ASDC}
\title{Adaptive skip dipeptide composition (ASDC)}
\usage{
ASDC(seqs, label = c())
}
\arguments{
\item{seqs}{is a FASTA file with amino acid sequences. Each sequence starts
with a '>' character. Also, seqs could be a string vector. Each element of the vector is a peptide/protein sequence.}

\item{label}{is an optional parameter. It is a vector whose length is equivalent to the number of sequences. It shows the class of
each entry (i.e., sequence).}
}
\value{
The function returns a feature matrix. The number of rows is equal to the number of sequences and
the number of columns is 400 (all posible amino acid pairs).
}
\description{
This descriptor sufficiently considers the correlation information present not only between adjacent residues but also between intervening residues.
This function calculates frequency of pair amino acids omitting gaps between them. Then this function normalizes each value through dividing each frequency by summition(frequencies).
}
\examples{


filePrs<-system.file("extdata/proteins.fasta",package="ftrCOOL")
mat<-ASDC(seqs=filePrs)

}
\references{
Wei L, Zhou C, Chen H, Song J, Su R. ACPred-FL: a sequence-based predictor using effective feature representation to improve the prediction of anti-cancer peptides. Bioinformatics (2018).
}
