% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FTUna.R
\name{FTUna}
\alias{FTUna}
\title{Fault Tree Unavailability}
\usage{
FTUna(belist, mcs, totaltime, delta, tol)
}
\arguments{
\item{belist}{a list containing all the basic components of a fault tree}

\item{mcs}{a list of minimal cuts sets}

\item{totaltime}{an integer value for the total time}

\item{delta}{a numeric value as time step}

\item{tol}{a numeric value for the tolerance level}
}
\value{
A list of unavailabilities for the basic events as well as the system,
         and their plots againts time steps
}
\description{
This function returns a list where the first element is a data frame of unavailabilities
and the second element is the plot of the unavailabilities
}
\examples{
A<-list(
 states=c("OK","F"),
 G=rbind(c(NA,1),
         c(1,NA)),
dist=c("exp", "exp"),
 param=list(c(0.1), c(1))
)

B<-list(
 states=c("OK","F"),
 G=rbind(c(NA,1),
         c(1,NA)),
 dist=c("exp", "exp"),
 param=list(c(0.01), c(2))
)


C<-list(
 states=c("OK","F"),
 G=rbind(c(NA,1),
         c(1,NA)),
 dist=c("exp", "weibull"),
param=list(c(0.1), c(5,2))
)

D<-list(
 states=c("OK", "F"),
 G=rbind(c(NA, 1),
         c(1,NA)),
 dist=c("lnorm", "exp"),
 param=list(c(2, 0.1), 2)
)

BElist<-list(A,B,C,D)
names(BElist)<-c("A","B","C","D")
MCS<-list(c("A", "C", "D"), c("B", "C", "D"))

x<-FTUna(BElist, MCS, 5, 0.2, 1e-07)

# Unavailabilities
x$Unavailability

#Plots
x$Plot

}
