% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/days_frost.R
\name{days_frost}
\alias{days_frost}
\title{Estimates the occurence of spring frosts}
\usage{
days_frost(mintemps, fendates, lastday = 181)
}
\arguments{
\item{mintemps}{a dataframe with minimum daily temperatures. Must contain
the columns julian day of year (DOY )and the minimum daily temperature (Tmin).}

\item{fendates}{a dataframe with the day of occurrence of the phenological
stages. Must contain julian day of occurrence of the phenological
stage (DOY) and the critical frost temperature for 10% (LT_10) and 90%
(LT_90) for each stage.}

\item{lastday}{the last day (day of the year) to evaluate. By default, 
lastday = 181 (June 30th).}
}
\value{
a dataframe with the columns
number of days in which Tmin is equal or below Tcrit.
}
\description{
(This is an internal function for spring_frost) not intended
to be stand alone used 
The function evaluates the early and spring frosts occurring
during a season. It compares minimum daily temperature (Tmin) with the critical
temperature (Tcrit). Daily critical temperatures are linearly
interpolated from a user-provided dataframe with critical temperatures for
key phenological stages and the day of occurrence of the stages.
The function checks each day between the first date if Tmin is below Tcrit
and, if so, that day is considered as a frost day (Fday). The last day evaluated
is DOY 181.
}
\author{
Carlos Miranda, \email{carlos.miranda@unavarra.es}
}
\keyword{internal}
