% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz_centsums.R
\name{as.centsums}
\alias{as.centsums}
\alias{as.centsums.default}
\title{Coerce to a centsums object.}
\usage{
as.centsums(
  x,
  order = 3,
  na.rm = TRUE,
  wts = NULL,
  check_wts = FALSE,
  normalize_wts = FALSE
)

\method{as.centsums}{default}(
  x,
  order = 3,
  na.rm = TRUE,
  wts = NULL,
  check_wts = FALSE,
  normalize_wts = FALSE
)
}
\arguments{
\item{x}{a numeric, array, or matrix.}

\item{order}{the order, defaulting to \code{length(sums)+1}.}

\item{na.rm}{whether to remove \code{NA}.}

\item{wts}{an optional vector of weights. Weights are \sQuote{replication}
weights, meaning a value of 2 is shorthand for having two observations
with the corresponding \code{v} value. If \code{NULL}, corresponds to
equal unit weights, the default. Note that weights are typically only meaningfully defined
up to a multiplicative constant, meaning the units of weights are
immaterial, with the exception that methods which check for minimum df will,
in the weighted case, check against the sum of weights. For this reason,
weights less than 1 could cause \code{NA} to be returned unexpectedly due
to the minimum condition. When weights are \code{NA}, the same rules for checking \code{v}
are applied. That is, the observation will not contribute to the moment
if the weight is \code{NA} when \code{na_rm} is true. When there is no
checking, an \code{NA} value will cause the output to be \code{NA}.}

\item{check_wts}{a boolean for whether the code shall check for negative
weights, and throw an error when they are found. Default false for speed.}

\item{normalize_wts}{a boolean for whether the weights should be
renormalized to have a mean value of 1. This mean is computed over elements
which contribute to the moments, so if \code{na_rm} is set, that means non-NA
elements of \code{wts} that correspond to non-NA elements of the data
vector.}
}
\value{
A centsums object.
}
\description{
Convert data to a \code{centsums} object.
}
\details{
Computes the raw sums on data, and stuffs the results into a 
\code{centsums} object.
}
\note{
The moment computations provided by fromo are 
numerically robust, but will often \emph{not} provide the
same results as the 'standard' implementations,
due to differences in roundoff. We make every attempt to balance
speed and robustness. User assumes all risk from using
the fromo package.
}
\examples{
set.seed(123)
x <- rnorm(1000)
cs <- as.centsums(x, order=5)
}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}
