% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_known_ratio.R
\name{.knownqpcr_loglike}
\alias{.knownqpcr_loglike}
\title{Log-likelihood of getting Cq values when exact allele mixing ratios are known.}
\usage{
.knownqpcr_loglike(X, A, trueY, Digest, Gene, Cq)
}
\arguments{
\item{X}{A numeric vector that stores the current parameter sizes of \code{meanDNA}, \code{targetScale}, \code{baseChange}, \code{sdMeasure}, \code{zeroAmount}, and \code{EPCR} in log scale.}

\item{A}{Optionally, you can specify relative DNA content between the samples, as a numeric vector having the same length as the Cq data. If present, \code{A} must not include missing values. It is the counterpart of the \code{N} argument in \code{\link{freqpcr}()}, whereas an element of \code{A} is not restricted to integer. Because the concentration as a whole is also adjusted with the parameter \code{meanDNA} (see Value section), \code{A} is used exclusively to reflect the relative contents between the sample solutions. Otherwise, \code{A} should be left unspecified (the default is 1 for all replicates).}

\item{trueY}{A numeric vector having the same length as the Cq data. \code{trueY[i]} signifies the exact allele frequency in the \emph{i}th sample. The values must be between 0 and 1, and \code{NA} is not allowed. To improve the estimation accuracy, it is better to include the settings y == 0 (pure S solution) and y == 1 (pure R) in your dataset.}
}
\value{
A scalar of the log likelihood.
}
\description{
Internal function to return the log-likelihood getting the four Cq measurements under true allele frequency for each bulk sample is known.
}
\keyword{internal}
