% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cspline.R
\name{open_curve}
\alias{open_curve}
\alias{plot.curve}
\alias{points.curve}
\alias{lines.curve}
\alias{closed_curve}
\alias{bezier_curve}
\title{Curved Interpolation}
\usage{
open_curve(x, y = NULL, n = 100 * length(z), asp = 1, ...)

\method{plot}{curve}(
  x,
  y = NULL,
  type = "l",
  lty = "solid",
  xpd = NA,
  pch = 20,
  ...,
  include_points = TRUE
)

\method{points}{curve}(x, pch = 20, xpd = NA, ...)

\method{lines}{curve}(x, xpd = NA, ...)

closed_curve(x, y = NULL, n0 = 500 * length(z0), asp = 1, ...)

bezier_curve(x, y = NULL, n = 500, t = seq(0, 1, length.out = n), ...)
}
\arguments{
\item{x, y}{Any of the forms used to specify a 2-d set of points or an object of class "curve"}

\item{n, n0}{number of points in the interpolating curve}

\item{asp}{the relative scale for x versus that of y}

\item{...}{additional arguments past on to other methods}

\item{pch, type, lty, xpd}{plot arguments or traditional graphics parameters}

\item{include_points}{logical:should points be included in the plot?}

\item{t}{for Bezier curves, parameter value sequence ranging from 0 to 1}
}
\value{
a list with components x, y, and points, of S3 class "curve"
}
\description{
Interpolate between ordered 2-d points with a smooth curve.  open_curve() produces an
open curve; closed_curve() produces a closed curve.  Bezier curves are also provided.
}
\examples{
oldPar <- par(pty = "s", mfrow = c(2, 2), mar = c(1,1,2,1), xpd = NA)
z <- (complex(argument = seq(-0.9*base::pi, 0.9*base::pi, length = 20)) +
     complex(modulus = 0.125, argument = runif(20, -base::pi, base::pi))) *
     complex(argument = runif(1, -base::pi, base::pi))

plot(z, asp=1, axes = FALSE, ann = FALSE, panel.first = grid())
title(main = "Open")
segments(Re(z[1]), Im(z[1]), Re(z[20]), Im(z[20]), col = "grey", lty = "dashed")
lines(open_curve(z), col = "red")

plot(z, asp=1, axes = FALSE, ann = FALSE, panel.first = grid())
title(main = "Closed")
lines(closed_curve(z), col = "royal blue")

plot(z, asp=1, axes = FALSE, ann = FALSE, panel.first = grid())
title(main = "Bezier")
lines(bezier_curve(z), col = "dark green")

plot(z, asp=1, axes = FALSE, ann = FALSE, panel.first = grid())
title(main = "Circle")
lines(complex(argument = seq(-base::pi, base::pi, len = 500)),
      col = "purple")

par(oldPar)
}
