% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freewall.R
\name{freewall}
\alias{freewall}
\title{The 'freewall' widget}
\usage{
freewall(
  images,
  backgroundImages = FALSE,
  widths = 100,
  heights = NULL,
  width = "100\%",
  draggable = FALSE,
  animate = TRUE,
  cellW = 100,
  cellH = 100,
  delay = 0,
  fixSize = NULL,
  gutterX = 10,
  gutterY = 10,
  keepOrder = TRUE,
  rightToLeft = FALSE,
  bottomToTop = FALSE,
  elementId = NULL
)
}
\arguments{
\item{images}{character vector of paths or urls to some images; for a
Shiny app, the image files must be located in the www subfolder}

\item{backgroundImages}{Boolean, whether to render the images with the
CSS property \code{background-image} or with \code{img} elements}

\item{widths}{the widths of the images in pixels; if a single value is given,
it will be used for all images}

\item{heights}{the heights of the images in pixels; if a single value is given,
it will be used for all images; setting the heights is necessary if
\code{backgroundImages=TRUE}, otherwise this argument can be set to
\code{NULL}}

\item{width}{the width of the container}

\item{draggable}{Boolean, whether to enable draggability}

\item{animate}{Boolean, whether to animate}

\item{cellW}{width of unit, a number of pixels or \code{"auto"}}

\item{cellH}{height of unit, a number of pixels or \code{"auto"}}

\item{delay}{time delay for showing an item}

\item{fixSize}{see \href{https://kombai.github.io/freewall/#options}{freewall options}}

\item{gutterX}{space between columns, a number of pixels or \code{"auto"}}

\item{gutterY}{space between rows, a number of pixels or \code{"auto"}}

\item{keepOrder}{Boolean, whether to keep the order of the images}

\item{rightToLeft}{Boolean, whether to let the layout start render from
right to left}

\item{bottomToTop}{Boolean, whether to let the layout start render from
bottom to top}

\item{elementId}{a HTML id for the container (usually useless)}
}
\value{
A \code{htmlwidget} object.
}
\description{
Creates a grid of images.
}
\examples{
freewall(
  nature(), widths = 200, cellW = 200, cellH = 200, draggable = TRUE
)
}
