% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_surface.R
\name{convert_surface}
\alias{convert_surface}
\title{Convert Freesurfer Surface}
\usage{
convert_surface(infile, ...)
}
\arguments{
\item{infile}{Input surface file}

\item{...}{additional arguments to pass to 
\code{\link{mris_convert}}}
}
\value{
List of 3 elements: a header indicating the number of 
vertices and faces, the vertices, and the faces
}
\description{
Reads in a surface file from Freesurfer and separates
into vertices and faces
}
\note{
This was adapted from the gist: 
\url{https://gist.github.com/mm--/4a4fc7badacfad874102}
}
\examples{
if (have_fs()) {
infile = file.path(fs_subj_dir(), 
                   "bert", "surf", "rh.pial")
res = convert_surface(infile = infile)
}
}
