% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetANOVA.R
\name{NetANOVA}
\alias{NetANOVA}
\title{Fréchet ANOVA for Networks}
\usage{
NetANOVA(Ly = NULL, group = NULL, optns = list())
}
\arguments{
\item{Ly}{A list (length n) of m by m matrices or a m by m by n array where
\code{Ly[, , i]} contains an m by m matrix, which can be either graph 
Laplacian matrices or covariance matrices or correlation matrices.}

\item{group}{A vector containing the group memberships of the corresponding 
matrices in \code{Ly}.}

\item{optns}{A list of control parameters specified by 
\code{list(name = value)}. See `Details`.}
}
\value{
A \code{NetANOVA} object --- a list containing the following fields:
\item{pvalAsy}{A scalar holding the asymptotic \eqn{p}-value.}
\item{pvalBoot}{A scalar holding the bootstrap \eqn{p}-value. 
  Returned if \code{optns$boot} is TRUE.}
\item{optns}{The control options used.}
}
\description{
Fréchet analysis of variance for graph Laplacian matrices, 
  covariance matrices, or correlation matrices 
  with respect to the Frobenius distance.
}
\details{
Available control options are:
\describe{
\item{boot}{Logical, also compute bootstrap \eqn{p}-value if \code{TRUE}. 
  Default is \code{FALSE}.}
\item{R}{The number of bootstrap replicates. Only used when \code{boot} 
  is \code{TRUE}. Default is 1000.}
}
}
\examples{
\donttest{
set.seed(1)
n1 <- 100
n2 <- 100
gamma1 <- 2
gamma2 <- 3
Y1 <- lapply(1:n1, function(i) {
  igraph::laplacian_matrix(igraph::sample_pa(n = 10, power = gamma1, 
                                             directed = FALSE), 
                           sparse = FALSE)
})
Y2 <- lapply(1:n2, function(i) {
  igraph::laplacian_matrix(igraph::sample_pa(n = 10, power = gamma2, 
                                             directed = FALSE), 
                           sparse = FALSE)
})
Ly <- c(Y1, Y2)
group <- c(rep(1, n1), rep(2, n2))
res <- NetANOVA(Ly, group, optns = list(boot = TRUE))
res$pvalAsy # returns asymptotic pvalue
res$pvalBoot # returns bootstrap pvalue
}
}
\references{
\itemize{
\item \cite{Dubey, P. and Müller, H.G., 2019. Fréchet analysis of variance for random objects. Biometrika, 106(4), pp.803-821.}
}
}
