% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GloSpheReg.R
\name{GloSpheReg}
\alias{GloSpheReg}
\title{Global Fréchet Regression for Spherical Data}
\usage{
GloSpheReg(xin = NULL, yin = NULL, xout = NULL)
}
\arguments{
\item{xin}{A vector of length \eqn{n} or an \eqn{n}-by-\eqn{p} matrix with input measurement points.}

\item{yin}{An \eqn{n}-by-\eqn{m} matrix holding the spherical data, of which the sum of squares of elements within each row is 1.}

\item{xout}{A vector of length \eqn{k} or an \eqn{k}-by-\eqn{p}  with output measurement points; Default: the same grid as given in \code{xin}.}
}
\value{
A list containing the following components:
\item{xout}{Input \code{xout}.}
\item{yout}{A \eqn{k}-by-\eqn{m} matrix holding the fitted responses, of which each row is a spherical vector, corresponding to each element in \code{xout}.}
\item{xin}{Input \code{xin}.}
\item{yin}{Input \code{yin}.}
}
\description{
Global Fréchet regression for spherical data with respect to the geodesic distance.
}
\examples{
\donttest{
n <- 101
xin <- seq(-1,1,length.out = n)
theta_true <- rep(pi/2,n)
phi_true <- (xin + 1) * pi / 4
ytrue <- apply( cbind( 1, phi_true, theta_true ), 1, pol2car )
yin <- t( ytrue )
xout <- xin
res <- GloSpheReg(xin=xin, yin=yin, xout=xout)
}
}
\references{
\cite{Petersen, A., & Müller, H.-G. (2019). "Fréchet regression for random objects with Euclidean predictors." The Annals of Statistics, 47(2), 691--719.}
}
