% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_missing.R
\name{filter_missing}
\alias{filter_missing}
\alias{filter_missing.data.frame}
\title{filter out missings}
\usage{
filter_missing(.data, ..., remove_inf = TRUE)

\method{filter_missing}{data.frame}(.data, ..., remove_inf = TRUE, condition = c("any", "all"))
}
\arguments{
\item{.data}{dataframe}

\item{...}{tidyselect. default selection is all columns}

\item{remove_inf}{logical. default is to also remove \code{Inf} values. set to \code{FALSE} otherwise.}

\item{condition}{defaults to "any". in which case removes rows if \code{NA} is in any specified column. "all" will remove rows only if each specified column is missing}
}
\value{
data frame
}
\description{
More complex wrapper around \code{dplyr::filter(!is.na())} to remove \code{NA} rows using tidyselect. If any specified column contains an \code{NA}
the whole row is removed. Reports the amount of rows removed containing \code{NaN}, \code{NA}, \code{Inf}, in that order.
For example if one row contains \code{Inf} in one column and  in another, the removed row will be counted in the \code{NA} tally.
}
\details{
S3 method, can also be used on vectors
}
\examples{

tibble::tibble(x = c(NA, 1L, 2L, NA, NaN, 5L, Inf),
y = c(1L, NA, 2L, NA, Inf, 5L, Inf)) -> tbl1

tbl1

# remove any row with a missing or Inf
tbl1 \%>\%
filter_missing()

# remove any row with Na or NaN in the x column
tbl1 \%>\%
filter_missing(x, remove_inf = FALSE)

# only remove rows where every entry is Na, NaN, or Inf
tbl1 \%>\%
filter_missing(condition = "all")
}
