% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fract3D.R
\name{fract3D}
\alias{fract3D}
\title{Calculates the fractal dimension of a 3D (sliced) image}
\usage{
fract3D(
  dir = NULL,
  box.size = NULL,
  dist.slice = NULL,
  save.dir = NULL,
  save.name = NULL
)
}
\arguments{
\item{dir}{Specify a directory containing the folder/s with the image/s to be analysed.}

\item{box.size}{A vector specifing the box size steps (in pixel) to be used to calculate fractal dimension. By default (NULL) box.size = c(1,2,4,8,16,32,64,128,256,512). Minimun box size cannot be less then 1, corresponding to 1 pixel of the image. Box size steps must be integer.}

\item{dist.slice}{The distance between slices. By default (NULL) dist.slice = 1. Distance between slice must be an integer number.}

\item{save.dir}{Optional. Set the name of an output folder to save the data as *.rds.}

\item{save.name}{Optional. Provide a name for the output data.}
}
\value{
\code{fract3D} returns a list containing the following components:\cr

\code{D} - A dataframe with the estimated fractal dimension.\cr

\code{raw.dat} - A dataframe with the raw data used to calculate the fractal dimension. The data frame contains the name of the image (id), the box size steps (box.size), and the number of boxes for each box size step (box).
}
\description{
This function calculates the fractal dimension of a black area in a three-dimensional image using the method of box-counting.
}
\details{
The fuction calculates the fractal dimension (D) of a 3D image by the method of box-counting. Box-counting method is useful to calculate the fractal dimension of various sets of any dimension and patterns with or withouth self-similarity (Klinkenberg, 1994).
The method overlay a series of cubes of different size (box.size x box.size x boxsize), with minimun size that is equal to the resolution of the image. Then, for each box size step the function keep track of the number of cubes occupied by the black area into the image. Finally, fractal dimension (D) is estimated by linear regression of log(n°boxes) on log(box.size).
}
\note{
The function analyze the fractal dimension of a black area into an image. Then, the images must be converted in black and white before analysis.\cr
IMPORTANT: images slices must be numerated as 00, 01,02 ... 10, 11 etc...\cr
Usually, the box sizes should change as a function of a power of two so that they will be evenly spaced in the log space. However, this can result in too few points to fit linear regression. Therefore, according to Dubuc et al. (1989) the function allow to use box.size from 1 to +inf not necessarly with dyadic step.
}
\examples{
\dontrun{
# The example below calculates the fractal dimension of 3D sliced image/s
# contained into folder/s that are placed into "source.dir".
# Then, a file named "res.rds" is saved into the "output" folder.
# The distance between sliced image is 10 px.

fct3D <- fract3D(dir = "source.dir",
                 dist.slice = 10,
                 box.size = c(1,2,4,8,16,32,64,128,256,512),
                 save.dir = "output/", save.name = "res")

fct3D$D # a data frame with the estimated fractal dimension
fct3D$raw.dat # the raw data from which fractal dimension was calculated
}
}
\references{
\itemize{
\item Mandelbrot B.B. (1982) - \emph{The fractal Geometry of Nature}. San Francisco: W.H. Freman.
\item Klinkenberg B. (1994) - \emph{A Review of methods used to determine the fractal dimension of linear features}. Mathematical Geology, vol. 26, n° 1. doi: 10.1007/BF02065874
\item Dubuc B., Quiniou J.F., Roques-Carmes C., Tricot C., Zucker S.W. (1989) - \emph{Evaluating the fractal dimension of profiles}. Physical Review A, vol. 39, n° 3. doi: https://doi.org/10.1103/PhysRevA.39.1500
\item Taud H and Parrot J-F (2005) - \emph{Measurement of DEM roughness using the local fractal dimension}. Géomorphologie: relief, processus, environnement: 4, 327-338. doi: 10.4000/geomorphologie.622
}
}
\seealso{
\code{fract3D} to estimate the fractal dimension of a 3D (sliced) image/s.
}
