% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fqi_metrics.R
\name{all_metrics}
\alias{all_metrics}
\title{Print a Summary of Non-Weighted FQA Metrics}
\usage{
all_metrics(x, key = "name", db, allow_no_c = TRUE)
}
\arguments{
\item{x}{A data frame containing a list of plant species. This data frame
must have one of the following columns: \code{name} or \code{acronym}. For cover-weighted or
relative functions, this data frame must also have a column called \code{cover} containing
cover values and ideally a column containing plot IDs.}

\item{key}{A character string representing the column that will be used to join
the input data frame \code{x} with the regional FQA database. If a value is not specified, the
default is \code{"name"}. \code{"name"} and \code{"acronym"} are the only acceptable
values for \code{key}.}

\item{db}{A character string representing the regional FQA database to use. See
\code{db_names} for a list of potential values and the \code{fqadata} R package
where the databases are hosted.}

\item{allow_no_c}{Boolean (TRUE or FALSE). If TRUE, allow species that are found in the
regional FQA database but have not been assigned a C Values. If FALSE, omit species that have not
been assigned C Values.}
}
\value{
A data frame
}
\description{
\code{all_metrics} calculates and prints a summary of all non cover-weighted metrics,
including Species Richness, Native Species Richness, Introduced Species Richness,
\% of species within C value ranges, Mean C, Native Mean C, Total FQI, Native FQI,
Adjusted FQI, Mean Wetness, Native Mean Wetness and \% Hydrophytes.
}
\examples{
plant_list <- crooked_island
all_metrics(x = plant_list, key = "acronym", db = "michigan_2014")
}
