% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fdply.R
\name{fdply}
\alias{fdply}
\title{Read some chunks from a file into a \code{data.table}}
\usage{
fdply(
  input,
  nblocks = 1,
  key.sep = "\\t",
  sep = "\\t",
  skip = 0,
  colClasses = NULL,
  header = TRUE,
  stringsAsFactors = FALSE,
  select = NULL,
  drop = NULL,
  col.names = NULL,
  parallel = 1
)
}
\arguments{
\item{input}{Path of the input file.}

\item{nblocks}{The number of blocks to read.}

\item{key.sep}{The character that delimits the first field from the rest.}

\item{sep}{The field delimiter (often equal to \code{key.sep}).}

\item{skip}{Number of lines to skip at the beginning of the file}

\item{colClasses}{Vector or list specifying the class of each field.}

\item{header}{Whether the file has a header.}

\item{stringsAsFactors}{Whether to convert strings into factors.}

\item{select}{The columns (names or numbers) to be read.}

\item{drop}{The columns (names or numbers) not to be read.}

\item{col.names}{Names of the columns.}

\item{parallel}{Number of cores to use.}
}
\value{
A \code{data.table} containing the file truncated to the number of
blocks specified.
}
\description{
This function is useful to quickly glance at a big chunked file. It is similar
to the \code{head()} function, except that it does not read the first few lines, but
rather the first few blocks of the file. By default, only the first block will be read;
it is not advisable to read a large number of blocks in this way because they may
occupy a lot of memory. The blocks are saved to a \code{data.table}. See \code{?fplyr}
for the definitions of chunked file and block.
}
\section{Slogan}{

fdply: from \strong{f}ile to \strong{d}ata.table
}

