% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{FORCE}
\alias{FORCE}
\alias{XFORCE}
\title{FORCE panel SNP data}
\format{
Both \code{FORCE} and \code{XFORCE} are data frames with the following columns:
\itemize{
\item \code{CHROM}: Chromosome
\item \code{MARKER}: Marker name (rs number)
\item \code{MB}: Physical position in megabases (GRCh38)
\item \code{A1}: First allele
\item \code{A2}: Second allele
\item \code{FREQ1}: Allele frequency of \code{A1}
}
}
\source{
Tillmar et al. The FORCE Panel: An All-in-One SNP Marker Set for
Confirming Investigative Genetic Genealogy Leads and for General Forensic
Applications. Genes. (2021)
}
\usage{
FORCE

XFORCE
}
\description{
Data frames describing the FORCE panel of SNPs for forensic genetics (Tillmar
et al., 2021). We provide here two subsets of the complete panel: the
autosomal kinship SNPs (\code{FORCE}, n = 3930) and the X-chromosomal SNPs
(\code{XFORCE}, n = 246). To attach the markers to a pedigree, use
\code{\link[pedtools:setSNPs]{pedtools::setSNPs()}} (see Examples).
}
\details{
Allele frequencies were retrieved from Ensembl using the REST API, with the
population \verb{1000GENOMES:phase_3:ALL} as primary source. For 9 SNPs where this
was unavailable, \code{gnomADg:ALL} was used instead.

One SNP - rs2323964 - was excluded due to lack of Ensembl/dbSNP support.

For details, the code used to download and process the data is available in
the \code{data-raw} folder on GitHub:
https://github.com/magnusdv/forrel/tree/master/data-raw

\emph{Note}: The autosomal dataset (\code{FORCE}) was updated in version 1.8.1, adding 15
markers that were previously missing and revising some frequencies. The
previous version is available via:

\if{html}{\out{<div class="sourceCode">}}\preformatted{pth = system.file("extdata/FORCE_old.txt", package = "forrel")
oldforce = read.table(pth, header = TRUE)
}\if{html}{\out{</div>}}
}
\examples{
x = setSNPs(nuclearPed(), snpData = FORCE)
summary(x)

getMap(x, markers = 1:3)
getFreqDatabase(x, markers = 1:3)

}
\keyword{datasets}
