% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split.terms.R
\name{split_terms}
\alias{split_terms}
\title{Split object into terms}
\usage{
split_terms(x, recursive = FALSE)
}
\arguments{
\item{x}{object to split terms from}

\item{recursive}{logical; whether to split terms recursively in parenthetical
enclosed terms  (depth-first).  (Default: FALSE)}
}
\value{
experession vector of terms
}
\description{
Split formulas, call and expressions into terms.
}
\details{
Unlike the [terms()] function, `split_terms` does not use [stats::terms()]
and instead just splits `x` into an **expression vector** of terms. (Terms 
are the mathematical notion of terms). The signs of the terms are preserved.
   
If `recursive` is `TRUE`, splitting occurs recursively, i.e. parsing of the 
input descends into parenthetical expressions `(...)`.  

See **examples**.
}
\examples{
  
  split_terms(1)                   # 1
  split_terms( quote(a) )          # a     
  split_terms( quote(-a) )         # -a   
  split_terms( quote(a+1) )        # a, 1
  split_terms( quote(1+a) )        # 1, a
  split_terms( quote(-1+a) )       # -1, a
  split_terms( quote(-1-a) )
  
  split_terms( quote(a+b+c) )      # a,b,c
  split_terms( quote((a+b)+1) )    # (a+b),1
  split_terms( quote((a+b)+1), recursive=TRUE )    # a,b,1
  split_terms( quote((a-b)+1), recursive=TRUE )    # a,-b,1
  split_terms( quote(-a) )         # -a
  
  split_terms( quote(a-1) )        # a, -1
  split_terms( quote(-a-1))        # -a, -1
  split_terms( quote( -(a+1) ) )   # -(a+1)
  split_terms( quote( -(a+1) ), recursive=TRUE )  # -a,-1
  
  split_terms( quote( ---a ))
  split_terms( quote( -(a+(b-(c+d)))), recursive=TRUE )
  
}
\references{
* [SO: How to split a formula](https://stackoverflow.com/questions/39155701/how-to-split-a-formula-in-r)
}
\seealso{
* [terms()]
}
