% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_LRs.R
\name{compute_LRs}
\alias{compute_LRs}
\title{Compute Likelihood Ratios (LRs)}
\usage{
compute_LRs(conditioned, unconditioned)
}
\arguments{
\item{conditioned}{A dataframe with at least the columns 'hair_colour', 'skin_colour',
'eye_colour', and 'numerators'.}

\item{unconditioned}{A dataframe with at least the columns 'hair_colour', 'skin_colour',
'eye_colour', and 'f_h_s_y'.}
}
\value{
A dataframe with the merged data and computed LRs.
}
\description{
This function calculates the Likelihood Ratios (LRs) for each combination of hair colour,
skin colour, and eye colour between two datasets. It assumes one dataset (\code{conditioned})
contains numerators and the other (\code{unconditioned}) contains denominators.
}
\examples{
data <- simRef()
conditioned <- conditionedProp(data, 1, 1, 1, 0.01, 0.01, 0.01) 
unconditioned <- refProp(data)
compute_LRs(conditioned, unconditioned)
}
