% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_windows.R
\name{plot.windows}
\alias{plot.windows}
\title{Plot validation datasets}
\usage{
\method{plot}{windows}(x, lagged_df, show_labels = TRUE, group_filter = NULL, ...)
}
\arguments{
\item{x}{An object of class 'windows' from \code{create_windows()}.}

\item{lagged_df}{An object of class 'lagged_df' from \code{create_lagged_df()}.}

\item{show_labels}{Boolean. If \code{TRUE}, show validation dataset IDs on the plot.}

\item{group_filter}{Optional. A string for filtering plot results for grouped time series (e.g., \code{"group_col_1 == 'A'"}).
This string is passed to \code{dplyr::filter()} internally.}

\item{...}{Not used.}
}
\value{
A plot of the outer-loop nested cross-validation windows of class 'ggplot'.
}
\description{
Plot validation datasets across time.
}
\examples{
# Sampled Seatbelts data from the R package datasets.
data("data_seatbelts", package = "forecastML")

# Example - Training data for 3 horizon-specific models w/ common lags per predictor.
horizons <- c(1, 6, 12)
lookback <- 1:15

data_train <- create_lagged_df(data_seatbelts, type = "train", outcome_col = 1,
                               lookback = lookback, horizon = horizons)

# All historical window lengths of 12 plus any partial windows at the end of the dataset.
windows <- create_windows(data_train, window_length = 12)
plot(windows, data_train)

# Two custom validation windows with different lengths.
windows <- create_windows(data_train, window_start = c(20, 80), window_stop = c(30, 100))
plot(windows, data_train)
}
