% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_skeleton.R
\name{create_skeleton}
\alias{create_skeleton}
\title{Remove the features from a lagged training dataset to reduce memory consumption}
\usage{
create_skeleton(lagged_df)
}
\arguments{
\item{lagged_df}{An object of class 'lagged_df' from \code{create_lagged_df(..., type = 'train')}.}
}
\value{
An S3 object of class 'lagged_df' or 'grouped_lagged_df': A list of data.frames with the
outcome column(s) and any grouping columns but with all other features removed.
A special attribute \code{skeleton = TRUE} is added.
}
\description{
\code{create_skeleton()} strips the feature data from a \code{create_lagged_df()} object
but keeps the outcome column(s), any grouping columns, and meta-data which allows the resulting
\code{lagged_df} to be used downstream in the \code{forecastML} pipeline. The main benefit is
that the custom modeling function passed in \code{train_model()} can read data directly from the
disk or a database when the dataset is too large to fit into memory.
}
\section{Methods and related functions}{


The output of \code{create_skeleton} can be passed into

\itemize{
  \item \code{\link{create_windows}}
}
}

