% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_to_sf.R
\name{data_to_sf}
\alias{data_to_sf}
\title{Convert a data frame into an sf object}
\usage{
data_to_sf(data)
}
\arguments{
\item{data}{a \code{tibble} or a \code{data.frame}, i.e. a FORCIS dataset or the
output of a \verb{filter_*()} function.}
}
\value{
An \verb{sf POINTS} object.
}
\description{
This function can be used to convert a \code{data.frame} into an \code{sf} object.
Note that coordinates (columns \code{site_lon_start_decimal} and
\code{site_lat_start_decimal}) are projected in the Robinson coordinate system.
}
\examples{
# Attach package ----
library("ggplot2")

# Import example dataset ----
file_name <- system.file(file.path("extdata", "FORCIS_net_sample.csv"),
                         package = "forcis")

net_data <- read.csv(file_name)

# Dimensions of the data.frame ----
dim(net_data)

# Filter by years ----
net_data_sub <- filter_by_year(net_data, years = 1992)

# Convert to an sf object ----
net_data_sub_sf <- data_to_sf(net_data_sub)

# World basemap ----
ggplot() +
  geom_basemap() +
  geom_sf(data = net_data_sub_sf)
}
