% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_to_long_format.R
\name{convert_to_long_format}
\alias{convert_to_long_format}
\title{Reshape and simplify FORCIS data}
\usage{
convert_to_long_format(data)
}
\arguments{
\item{data}{a \code{tibble} or a \code{data.frame}, i.e. a FORCIS dataset, except for
CPR North data.}
}
\value{
A \code{tibble} reshaped in a long format.
}
\description{
Reshapes FORCIS data by pivoting species columns into two columns: \code{taxa}
(taxon names) and \code{counts} (taxon abundances). It converts wider \code{data.frame}
to a long format.
}
\examples{
# Import example dataset ----
file_name <- system.file(file.path("extdata", "FORCIS_net_sample.csv"),
                         package = "forcis")

net_data <- read.csv(file_name)

# Dimensions of the data.frame ----
dim(net_data)

# Reshape data ----
net_data <- convert_to_long_format(net_data)

# Dimensions of the data.frame ----
dim(net_data)

# Column names ----
colnames(net_data)
}
