% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep_exp_data.R
\name{prep_exp_data}
\alias{prep_exp_data}
\title{Prepare Experimental Data}
\usage{
prep_exp_data(
  filenames,
  na.strings = c(",,", "[]", "None"),
  excl.vars = NULL,
  blacklist.vars = NULL,
  whitelist.vars = NULL,
  sort = TRUE
)
}
\arguments{
\item{filenames}{A (vector of) character(s) providing the raw experimental data file name(s). Files can be .txt, .csv, or any common type.}

\item{na.strings}{A (vector of) character(s) naming the strings that should be treated as NA.}

\item{excl.vars}{A (vector of) number(s) or character(s) providing the column number(s) or name(s)
of the data which will be used for spotting rows that are not trials, that is, rows that are
NA in each of the columns \code{excl.vars}.}

\item{blacklist.vars}{A (vector of) number(s) or character(s) providing the column number(s) or name(s)
of variables to be deleted from the data. NULL means no variable will be deleted.}

\item{whitelist.vars}{A (vector of) number(s) or character(s) providing the column number(s) or name(s)
of variables to be kept in the data. All others will be deleted. NULL means all variables will be kept.}

\item{sort}{TRUE or FALSE. If TRUE the data will be sorted by subject number and block number.}
}
\value{
A \code{data.table} of the class \code{exp.prep}.
}
\description{
Processing the experimental data by removing unnecessary variables and removing rows in the data
that are not trials. The output is a \code{data.table}.
}
\examples{
# Using example data from github which requires internet
if (curl::has_internet()) {
  url <- paste0("https://raw.githubusercontent.com/RaphaelHartmann/forceplate/",
                "main/data/subj13_exp_data.csv")
  
  # Safe download, handling potential errors
  tryCatch({
    filenames <- tempfile(pattern = c("subj13_exp_data"), tmpdir = tempdir(), fileext = ".csv")
    download.file(url, filenames)
    
    # prepare experimental data
    exp.dt <- prep_exp_data(filenames = filenames, excl.vars = 2:5)
    
    # Clean up
    unlink(filenames)
  }, error = function(e) {
    message("Failed to download data: ", e$message)
  })
}
                         
}
\author{
Raphael Hartmann & Anton Koger
}
