% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popup.R
\name{addPopup}
\alias{addPopup}
\alias{addTooltip}
\title{Create Fomantic UI Popup}
\usage{
addPopup(
  el,
  text,
  position = NULL,
  variation = NULL,
  inverted = FALSE,
  title = NULL,
  offset = NULL,
  settings = NULL,
  html = FALSE
)

addTooltip(el, text, position = NULL, variation = NULL, inverted = FALSE)
}
\arguments{
\item{el}{A UI element that the tooltip will be applied to}

\item{text}{Contents of the tooltip. Can either be a character string or an HTML object}

\item{position}{(Optional) Force the popup to appear in a direction relative to \code{el}. Choose a vertical
position from \code{"top", "bottom", ""} and a horizontal from \code{"left", "center", "right", ""}}

\item{variation}{(Optional) Add certain features to the popup
\describe{
\item{\code{mini, tiny, small, medium, large, huge}}{Affect the size of the font in the popup}
\item{\code{basic}}{Removes the pointing arrow of the popup}
\item{\code{fixed, wide} (addPopup only)\code{, very wide} (addPopup only)}{Affect the width of the popup}
}}

\item{inverted}{Should the colours of the popup be inverted?}

\item{title}{(Optional) Add a title to the popup. Only appears when \code{html = FALSE}}

\item{offset}{(Optional) A numeric value of the number of pixel to offset the tooltip by}

\item{settings}{Named list of settings to be applied to the popup. Check Fomantic UI website for full list.
For example \code{list(on = "click")} will mean the popup appears on a click rather than a hover.}

\item{html}{Is \code{text} valid HTML code? Defaults to \code{FALSE}}
}
\value{
\code{addTooltip} will return \code{el} with extra attributes added to the top level tag.

\code{addPopup} will return a \code{shiny.tag.list}, first similar to \code{addTooltip} an updated
version of \code{el}. Then a small JS script has been added to enable the popup.
}
\description{
Add a tooltip to an element that on hover will show extra information

\code{addTooltip} will only use a basic CSS tooltip with a limited amount of functionality, whereas \code{addPopup}
is initialised with JS, and can include more functionality
}
\examples{
addPopup(
  fui_el$label(id = "help_label", class = "small circular", "?"),
  "This can be used as a help icon in a shiny app",
  inverted = TRUE
)

addTooltip(
  fui_el$label(class = "small circular", "?"),
  "This can be used as a help icon in a shiny app"
)

}
\seealso{
\url{https://fomantic-ui.com/modules/popup.html}
}
