% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isotopes.R
\docType{data}
\name{nydal1996}
\alias{nydal1996}
\title{\eqn{{}^{14}C}{14C} Measurements in Atmospheric \eqn{CO_2}{CO2}}
\format{
A \code{data.frame} with 620 observations and 5 variables:
\describe{
\item{site}{\code{\link{character}}: sampling station.}
\item{start}{\code{\link{Date}}: beginning date of the sampling period.}
\item{end}{\code{\link{Date}}: ending date of the sampling period.}
\item{delta}{\code{\link{numeric}}: isotopic ratio \eqn{\Delta^{14}C}{\Delta14C} (per mil).}
\item{sigma}{\code{\link{numeric}}: error on \code{delta} (per mil).}
}
}
\source{
Nydal, R. and Lövseth, K. (1996). \emph{Carbon-14 Measurements in
Atmospheric CO2 from Northern and Southern Hemisphere Sites, 1962-1993}.
ORNL/CDIAC-93; NDP-057. Washington, DC: USDOE Office of Energy Research.
\doi{10.2172/461185}
}
\usage{
nydal1996
}
\description{
Corrected \eqn{{}^{14}C}{14C} measurements from air samples collected at five
Norwegian sites from 1962-1993.
}
\examples{
plot(
  x = nydal1996$start,
  y = nydal1996$delta,
  type = "p",
  xlab = "Date",
  ylab = expression(Delta^{14}*"C")
)
}
\seealso{
Other isotopic data: 
\code{\link{lisiecki2005}},
\code{\link{ngrip2004}},
\code{\link{ngrip2010}},
\code{\link{spratt2016}},
\code{\link{vegetation}}
}
\concept{isotopic data}
\keyword{datasets}
