% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial.R
\docType{data}
\name{cities}
\alias{cities}
\title{Roman cities}
\format{
A \code{data.frame} with 125 observations (Roman cities) and 8 variables:
\describe{
\item{name}{\code{\link{character}}: site Name.}
\item{area}{\code{\link{integer}}: site area, in hectares.}
\item{population}{\code{\link{integer}}: population estimate, following the
methodology in Hanson and Ortman (2017).}
\item{forum_area}{\code{\link{integer}}: total area of all fora/agorae in the site,
in square meters.}
\item{street_area}{\code{\link{integer}}: total area of streets in the site, in
square meters.}
\item{street_length}{\code{\link{integer}}: total length of streets in the site, in
meters.}
\item{street_width}{\code{\link{integer}}: average width of streets, in square
meters.}
\item{block_area}{\code{\link{integer}}: average area of a block, in square meters.}
}
}
\source{
Hanson, J. & Ortman, S. (2019). Population, area, and infrastructural
measures for Roman cities of the Imperial period. \emph{tDAR}.
\doi{10.6067/XCV8448563}.
}
\usage{
cities
}
\description{
A dataset of population, area, and infrastructural measures for Roman cities
of the Imperial period.
}
\references{
Hanson J. W. & Ortman S. G. (2017). A systematic method for estimating the
populations of Greek and Roman settlements. \emph{Journal of Roman Archaeology},
30: 301-324. \doi{10.1017/S1047759400074134}.

Hanson J. W., Ortman S. G., Bettencourt L. M. A. & Mazur L. C. (2019). Urban
form, infrastructure and spatial organisation in the Roman Empire.
\emph{Antiquity}, 93(369): 702-718. \doi{10.15184/aqy.2018.192}.
}
\seealso{
Other geographical data: 
\code{\link{inrap}}
}
\concept{geographical data}
\keyword{datasets}
