% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{deriv}
\alias{deriv}
\alias{fd_deriv1}
\alias{fd_deriv2}
\alias{deriv1}
\alias{deriv2}
\title{Numerical Derivatives via Finite Differences}
\usage{
fd_deriv1(f, x, i, h, fd_type)

fd_deriv2(f, x, i, j, h_i, h_j, fd_type)

deriv1(f, x, i, args, fd_type)

deriv2(f, x, i, j, args, fd_type)
}
\arguments{
\item{f}{Function to differentiate.}

\item{x}{Scalar at which to evaluate the derivative.}

\item{i}{First coordinate to differentiate.}

\item{h}{Step size in the first coordinate.}

\item{fd_type}{Type of derivative: \code{0} for symmetric difference, \code{1} for
forward difference, and \code{2} for backward difference.}

\item{j}{Second coordinate to differentiate.}

\item{h_i}{Step size in the first coordinate.}

\item{h_j}{Step size in the second coordinate.}

\item{args}{List of additional arguments from the function \code{richardson_args}.}
}
\value{
\code{fd_deriv1} and \code{fd_deriv2} return a single numeric value corresponding to
the first and second derivative via finite differences. \code{deriv1} and
\code{deriv2} return a list with the form of a \code{richardson_result} described in
section "Richardson Extrapolated Finite Differences" of the package
vignette.
}
\description{
Numerical Derivatives via Finite Differences
}
\examples{
args = richardson_args()

f = sin   # Try 2nd derivatives of a univariate function
x0 = 0.5
print(-sin(x0))  ## Exact answer for f''(x0)

fd_deriv2(f, x0, i = 0, j = 0, h_i = 0.001, h_j = 0.001, fd_type = 0)
fd_deriv2(f, x0, i = 0, j = 0, h_i = 0.001, h_j = 0.001, fd_type = 1)
fd_deriv2(f, x0, i = 0, j = 0, h_i = 0.001, h_j = 0.001, fd_type = 2)

deriv2(f, x0, i = 0, j = 0, args, fd_type = 0)

# Try 2nd derivatives of a bivariate function
f = function(x) { sin(x[1]) + cos(x[2]) }
x0 = c(0.5, 0.25)

print(-sin(x0[1]))  ## Exact answer for f_xx(x0)
print(-cos(x0[2]))  ## Exact answer for f_yy(x0)
print(0)         ## Exact answer for f_xy(x0,y0)

numDeriv::hessian(f, x0)

fd_deriv2(f, x0, i = 0, j = 0, h_i = 0.001, h_j = 0.001, fd_type = 0)
fd_deriv2(f, x0, i = 0, j = 0, h_i = 0.001, h_j = 0.001, fd_type = 1)
fd_deriv2(f, x0, i = 0, j = 0, h_i = 0.001, h_j = 0.001, fd_type = 2)

fd_deriv2(f, x0, i = 0, j = 1, h_i = 0.001, h_j = 0.001, fd_type = 0)
fd_deriv2(f, x0, i = 0, j = 1, h_i = 0.001, h_j = 0.001, fd_type = 1)
fd_deriv2(f, x0, i = 0, j = 1, h_i = 0.001, h_j = 0.001, fd_type = 2)

fd_deriv2(f, x0, i = 1, j = 1, h_i = 0.001, h_j = 0.001, fd_type = 0)
fd_deriv2(f, x0, i = 1, j = 1, h_i = 0.001, h_j = 0.001, fd_type = 1)
fd_deriv2(f, x0, i = 1, j = 1, h_i = 0.001, h_j = 0.001, fd_type = 2)

deriv2(f, x0, i = 1, j = 1, args, fd_type = 0)
deriv2(f, x0, i = 1, j = 1, args, fd_type = 1)
deriv2(f, x0, i = 1, j = 1, args, fd_type = 2)

}
