% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.R
\name{sim.restricted}
\alias{sim.restricted}
\title{Simulate data from a restricted factor model}
\usage{
sim.restricted(n, p, q = 2, heavy = FALSE)
}
\arguments{
\item{n}{sample size}

\item{p}{dimension}

\item{q}{number of unrestricted factors; number of restricted factors is given by \code{2 * q}}

\item{heavy}{if \code{heavy = FALSE}, common shocks are generated from \code{rnorm} whereas if \code{heavy = TRUE}, from \code{rt} with \code{df = 5} and then scaled by \code{sqrt(3 / 5)}}
}
\value{
a list containing
\item{data}{ \code{ts} object with \code{n} rows and \code{p} columns }
\item{q}{ number of factors}
\item{r}{ number of restricted factors}
}
\description{
Simulate the common component following an unrestricted factor model that admits a restricted representation;
see the model (C2) in the reference.
}
\examples{
common <- sim.restricted(500, 50)
}
\references{
Barigozzi, M., Cho, H. & Owens, D. (2024+) FNETS: Factor-adjusted network estimation and forecasting for high-dimensional time series. Journal of Business & Economic Statistics (to appear).

Owens, D., Cho, H. & Barigozzi, M. (2024+) fnets: An R Package for Network Estimation and Forecasting via Factor-Adjusted VAR Modelling. The R Journal (to appear).
}
