% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idio.R
\name{plot.threshold}
\alias{plot.threshold}
\title{Plotting the thresholding procedure}
\usage{
\method{plot}{threshold}(x, plots = c(TRUE, FALSE, TRUE), ...)
}
\arguments{
\item{x}{\code{threshold} object}

\item{plots}{logical vector, which plots to use (Ratio, Diff, CUSUM respectively)}

\item{...}{additional arguments}
}
\value{
A network plot produced as per the input arguments
}
\description{
Plotting method for S3 objects of class \code{threshold}.
Produces a plot visualising three diagnostics for the thresholding procedure, with threshold values t_k (x axis) against
(i) Ratio_k, the ratio of the number of non-zero to zero entries in the matrix, as the threshold varies
(ii) Diff_k, the first difference of \code{Ratio_k}
(iii) |CUSUM_k|, the absolute scaled cumulative sums of \code{Diff_k}
}
\details{
See Owens, Cho and Barigozzi (2024+) for further details.
}
\examples{
\dontrun{
library(fnets)
out <- fnets(data.unrestricted,
   var.args = list(n.cores = 2)
)
# Granger-causal network
th1 <- threshold(out$idio.var$beta)
plot(th1)
print(th1)
# Partial correlations
th2 <- threshold(out$lrpc$pc)
# Long-run partial correlations
th3 <- threshold(out$lrpc$lrpc)
}
}
\references{
Owens, D., Cho, H. & Barigozzi, M. (2024+) fnets: An R Package for Network Estimation and Forecasting via Factor-Adjusted VAR Modelling. The R Journal (to appear).
}
\seealso{
\link[fnets]{threshold}
}
