% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hrf.R
\name{empirical_hrf}
\alias{empirical_hrf}
\alias{gen_empirical_hrf}
\title{Generate an Empirical Hemodynamic Response Function}
\usage{
empirical_hrf(t, y, name = "empirical_hrf")

gen_empirical_hrf(...)
}
\arguments{
\item{t}{Time points.}

\item{y}{Values of HRF at time `t[i]`.}

\item{name}{Name of the generated HRF.}
}
\value{
An instance of type `HRF`.
}
\description{
`empirical_hrf` generates an empirical HRF using provided time points and values.
}
\examples{
# Create empirical HRF from data points
t_points <- seq(0, 20, by = 1)
y_values <- c(0, 0.1, 0.5, 0.9, 1.0, 0.8, 0.5, 0.2, 0, -0.1, -0.1, 
              0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
emp_hrf <- empirical_hrf(t_points, y_values)

# Evaluate at new time points
new_times <- seq(0, 25, by = 0.1)
response <- evaluate(emp_hrf, new_times)
}
\keyword{internal}
