% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.fm_segm}
\alias{plot.fm_segm}
\alias{lines.fm_segm}
\alias{plot.fm_segm_list}
\alias{lines.fm_segm_list}
\title{Draw \code{fm_segm} objects.}
\usage{
\method{plot}{fm_segm}(x, ..., add = FALSE)

\method{lines}{fm_segm}(
  x,
  loc = NULL,
  col = NULL,
  colors = c("black", "blue", "red", "green"),
  add = TRUE,
  xlim = NULL,
  ylim = NULL,
  rgl = FALSE,
  asp = 1,
  axes = FALSE,
  xlab = "",
  ylab = "",
  visibility = "front",
  ...
)

\method{plot}{fm_segm_list}(x, ...)

\method{lines}{fm_segm_list}(x, ...)
}
\arguments{
\item{x}{An \code{\link[=fm_segm]{fm_segm()}} object.}

\item{\dots}{Additional parameters, passed on to graphics methods.}

\item{add}{If \code{TRUE}, add to the current plot, otherwise start a new
plot.}

\item{loc}{Point locations to be used if \code{x$loc} is \code{NULL}.}

\item{col}{Segment color specification.}

\item{colors}{Colors to cycle through if \code{col} is \code{NULL}.}

\item{xlim, ylim}{X and Y axis limits for a new plot.}

\item{rgl}{If \code{TRUE}, use \code{rgl} for plotting.}

\item{asp}{Aspect ratio for new plots. Default 1.}

\item{axes}{logical; whether axes should be drawn on the plot.
Default FALSE.}

\item{xlab, ylab}{character; labels for the axes.}

\item{visibility}{If "front" only display mesh faces with normal pointing
towards the camera.}
}
\value{
None
}
\description{
Draws a \code{\link[=fm_segm]{fm_segm()}} object with generic or \code{rgl}
graphics.
}
\examples{
plot(fm_segm(fmexample$mesh, boundary = TRUE))
lines(fm_segm(fmexample$mesh, boundary = FALSE), col = 2)

}
\seealso{
\code{\link[=fm_segm]{fm_segm()}}, \link{plot.fm_mesh_2d}
}
\author{
Finn Lindgren \href{mailto:Finn.Lindgren@gmail.com}{Finn.Lindgren@gmail.com}
}
