% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fasterstress.R
\name{fasterstress}
\alias{fasterstress}
\title{Faster Stress Function}
\usage{
fasterstress(data = NULL, z = NULL, nsamples = 100, samplesize = 30)
}
\arguments{
\item{data}{an n by m multivariate data matrix.}

\item{z}{n by p matrix with coordinates.}

\item{nsamples}{number of samples}

\item{samplesize}{sample size}
}
\value{
n.stress normalized stress, mean over samples and observations

se standard error of se, standard deviation over samples
}
\description{
\code{fasterstress} calculates stochastic normalized stress.
Neither data nor distances based on z are optimally scaled.
}
\examples{
n <- 10000
m <- 10
data <- matrix( runif( n * m ), n, m )
p <- 2
zinit <- matrix( runif( n * p ), n, p )
# r <- fastermds( data = data, p = p, z = zinit )
# s <- fasterstress( data = data, z = r )

}
\references{
agrafiotis, and others, and busing
}
\author{
Frank M.T.A. Busing
}
