% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary.R
\name{getCov}
\alias{getCov}
\title{Covariance Computations Between Pairs of Distances (Independent Case)}
\usage{
getCov(X, p = 2)
}
\arguments{
\item{X}{The binary or real matrix}

\item{p}{The power \eqn{p} of \eqn{l_p^p}, i.e., \eqn{||x||_p^p = (x_1^p+...x_n^p)}}
}
\value{
The three distinct entries of covariance matrix, \eqn{(\alpha, \beta, \gamma)}
}
\description{
Computes covariance matrix entries and associated alpha, beta
and gamma quantities defined in Aw, Spence and Song (2023),
assuming the \eqn{P} features of the dataset \eqn{\mathbf{X}} are independent.
}
\details{
This is used in the large \eqn{P} asymptotics of the permutation test.

Dependencies: buildReverse, getLpDistance
}
