% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DoU-plot-units.R
\name{plot_units}
\alias{plot_units}
\title{Plot the spatial units classification}
\usage{
plot_units(
  units,
  classification = NULL,
  level1 = TRUE,
  extent = NULL,
  column = NULL,
  palette = NULL,
  labels = NULL,
  title = NULL,
  scalebar = FALSE,
  filename = NULL
)
}
\arguments{
\item{units}{object of class \code{sf}. The spatial units to be displayed on the plot}

\item{classification}{dataframe with the classification of the spatial units, as returned by \code{DoU_classify_units()}. If \code{NULL}, it is assumed that the classification results are merged in the \code{units} object.}

\item{level1}{logical. Whether the spatial units are classified according to level 1 of the Degree of Urbanisation (\code{TRUE}), or level 2 of the Degree of Urbanisation (\code{FALSE}).}

\item{extent}{SpatExtent or an object of class "bbox" (\code{sf}). If not \code{NULL}, the spatial units will be filtered based on the provided extent before plotting.}

\item{column}{character. Column name of the spatial units classification. By default, \code{"flexurba_L1"} when \code{level1=TRUE} and \code{"flexurba_L2"} when \code{level1=FALSE}.}

\item{palette}{named vector with the color palette used to plot the spatial units classification. If \code{NULL}, the standard color palette of the GHSL is used (see \code{GHSL_palette()}).}

\item{labels}{vector with the labels used in the legend. If \code{NULL}, the standard labels of the GHSL are used (see \code{GHSL_labels()}).}

\item{title}{character. Title of the plot.}

\item{scalebar}{logical. Whether to add a scale bar to the plot.}

\item{filename}{character. Path to the location to save the plot}
}
\value{
ggplot object
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

\code{plot_units()} has been renamed to \code{DoU_plot_units()} to create a more consistent API and to better indicate that this function is specifically designed for plotting the DEGURBA classification generated with \code{DoU_classify_units()}.
}
\keyword{internal}
