% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/state.pairs.CT.R
\name{state.pairs.CT}
\alias{state.pairs.CT}
\title{Function to extract state pair counts and observed (right) times.}
\usage{
state.pairs.CT(
  formula = NULL,
  data = NULL,
  whereQ = NULL,
  nstates = NULL,
  time = NULL,
  state = NULL,
  id = NULL
)
}
\arguments{
\item{formula}{Model specification.}

\item{data}{Data.}

\item{whereQ}{Placement of allowed transition intensities. Only for internal use. Defaults to \code{NULL} and is obtained automatically when \code{formula} is provided.}

\item{nstates}{Total number of states. Only for internal use. Defaults to \code{NULL} and is obtained automatically when \code{formula} is provided.}

\item{time}{Name of variable containing the time-to-event.}

\item{state}{Name of variable containing the states.}

\item{id}{Name of variable containing the unique code identifying the individuals.}
}
\value{
A table with the state-pair counts and a list with the observed (right) times for each transition.
}
\description{
Function to extract state pair counts and observed (right) times.
}
