% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3-methods.R
\name{credint}
\alias{credint}
\title{Credible Intervals for rjMCMC Results}
\usage{
credint(results, level = 0.95)
}
\arguments{
\item{results}{An object of class rjMCMC containing the output from the \code{rjMCMC} procedure, including posterior samples.}

\item{level}{The level for the credible intervals (default is 0.95).}
}
\value{
A data frame with estimates, lower, and upper bounds of the credible intervals.
}
\description{
This function calculates the posterior mean and credible intervals for parameters
from the rjMCMC results, including both intercept/exposure parameters and binary parameters.
The credible intervals are computed based on the specified confidence level.
}
\examples{
\donttest{
# Example dataset
data("simulated_data")

candsplinevars <- c("X_1")
candbinaryvars <- paste0("Z_", 1:5)
candinter <- c(candsplinevars, candbinaryvars)


results <- rjMCMC(simulated_data, candsplinevars, candbinaryvars, candinter,
                  outcome = "Y", factor_var = "trt")
credint(results)
}
}
