% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3-methods.R
\name{coef.rjMCMC}
\alias{coef.rjMCMC}
\title{Extract Posterior Mean Coefficients from rjMCMC Results}
\usage{
\method{coef}{rjMCMC}(object, ...)
}
\arguments{
\item{object}{An object of class rjMCMC containing the output from the \code{rjMCMC} procedure, which includes:
\describe{
\item{fixed_param}{Matrix of posterior samples for exposure intercept and main effect.}
\item{binary_param}{Matrix of posterior samples for binary variable parameters.}
\item{sigma_sq}{Matrix of posterior samples for the residual variance (sigma squared).}
\item{vars_prop_summ}{Posterior inclusion probabilities for candidate variables.}
\item{splines_fitted}{List of matrices containing fitted values for spline terms across iterations.}
\item{data_fit}{Original dataset used in the \code{rjMCMC} procedure.}
\item{candsplineinter}{Names of continuous candidate predictive spline variables.}
\item{candsplinevars}{Names of continuous candidate spline variables.}
\item{candbinaryvars}{Names of binary candidate variables.}
\item{candinter}{Names of interaction terms, which can include spline variables.}
\item{mcmc_specs}{MCMC sampler specifications, including the number of iterations, burn-in, thinning, and chains.}
}}

\item{...}{Additional arguments to be passed to other methods or functions.}
}
\value{
A numeric vector containing the posterior mean of the intercept, exposure, and binary parameters.
}
\description{
This function extracts the posterior means of the intercept, exposure parameters,
and binary parameters from the results of an rjMCMC model.
}
\examples{
\donttest{
# Example dataset
data("simulated_data")

candsplinevars <- c("X_1")
candbinaryvars <- paste0("Z_", 1:5)
candinter <- c(candsplinevars, candbinaryvars)


results <- rjMCMC(simulated_data, candsplinevars, candbinaryvars, candinter,
                  outcome = "Y", factor_var = "trt")
coef(results)
}
}
