% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/account_type.R
\name{fixer_account_type}
\alias{fixer_account_type}
\title{Set account type}
\usage{
fixer_account_type(type = c("free", "paid"))
}
\arguments{
\item{type}{Your \href{https://fixer.io/}{fixer.io} account type. Accepts
one of \code{"free"} or \code{"paid"}. If no value or an incorrect value
is given, account type will be set as \code{"free"}. This parameter is not
case sensitive.}
}
\description{
Paid accounts have access to additional features, including
SSL encryption of API requests using HTTPS. Account type must be set in
order to use HTTPS requests. Setting account type to \code{"paid"} when
using a free account will result in an error, even on features available to
free accounts. Setting account type to \code{"free"} when using a paid
account will have no impact on requests aside from using HTTP instead of
HTTPS to access the API. If you have a paid account but do not set
your account status you will not be able to use the HTTPS connection but
there will be no other impact on your usage of the API.

The \href{https://fixer.io/}{fixer.io} API still checks the
account type when receiving requests, so setting you account type here only
forces HTTPS instead of HTTP.
}
\examples{
\dontrun{
fixer_account_type("paid")
}
}
