% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{wwc_2019}
\alias{wwc_2019}
\alias{wwc_2019_forecasts}
\alias{wwc_2019_matches}
\title{2019 Women's World Cup Predictions}
\format{
2 dataframes about the 2019 Women's World Cup matches and teams

An object of class \code{spec_tbl_df} (inherits from \code{tbl_df}, \code{tbl}, \code{data.frame}) with 52 rows and 18 columns.
}
\source{
\url{https://projects.fivethirtyeight.com/soccer-api/international/2019/wwc_forecasts.csv}

\url{https://projects.fivethirtyeight.com/soccer-api/international/2019/wwc_matches.csv}
}
\usage{
wwc_2019_forecasts

wwc_2019_matches
}
\description{
The raw data behind the story
"2019 Women’s World Cup Predictions"
\url{https://projects.fivethirtyeight.com/2019-womens-world-cup-predictions/}
}
\section{wwc_2019_forecasts}{

A data frame with 192 rows representing 2019 Women's World Cup team match-by-match projections, and 21 variables:
\describe{
  \item{date}{Date match was played}
  \item{team}{Team}
  \item{group}{Assigned group for the group stage}
  \item{spi}{Soccer power index}
  \item{global_o}{SPI offensive rating}
  \item{global_d}{SPI defensive rating}
  \item{sim_wins}{Simulated number of wins}
  \item{sim_ties}{Simulated number of ties}
  \item{sim_losses}{Simulated number of losses}
  \item{sim_goal_diff}{Simulated difference between goals_scored and goals_against}
  \item{goals_scored}{The number of goals that a team is expected to score against an average team on a neutral field}
  \item{goals_against}{The number of goals that a team is expected to concede against an average team on a neutral field}
  \item{group_1}{Chance of winning group stage game 1}
  \item{group_2}{Chance of winning group stage game 2}
  \item{group_3}{Chance of winning group stage game 3}
  \item{group_4}{Chance of winning group stage game 4}
  \item{make_round_of_16}{Chance of playing in the round of 16}
  \item{make_quarters}{Chance of playing in the quarter-finals}
  \item{make_semis}{Chance of playing in the semi-finals}
  \item{make_final}{Chance of playing in the finals}
  \item{win_league}{Chance of winning the tournament}
  }
}

\section{wwc_2019_matches}{

2019 Women's World Cup Predictions
A data frame with 52 rows representing Women's World Cup matches, and 18 variables:
\describe{
  \item{date}{Date match was played}
  \item{team1}{Team 1}
  \item{team2}{Team 2}
  \item{spi1}{Soccer power index of team 1}
  \item{spi2}{Soccer power index of team 2}
  \item{prob1}{Probability that team 1 will win match}
  \item{prob2}{Probability that team 2 will win match}
  \item{prob_tie}{Probability that the teams will tie the match}
  \item{proj_score1}{Projected number of goals scored by team 1}
  \item{proj_score2}{Projected number of goals scored by team 2}
  \item{score1}{Actual number of goals scored by team 1}
  \item{score2}{Actual number of goals scored by team 2}
  \item{xg1}{Shot-based expected goals for team 1}
  \item{xg2}{Shot-based expected goals for team 2}
  \item{nsxg1}{Non-shot expected goals for team 1}
  \item{nsxg2}{Non-shot expected goals for team 2}
  \item{adj_score1}{Goals scored by team 1 accounting for the conditions under which each goal was scored}
  \item{adj_score2}{Goals scored by team 2 accounting for the conditions under which each goal was scored}
  }
}

\keyword{datasets}
