% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitPolyTools.R
\name{segtypeInfoSummary}
\alias{segtypeInfoSummary}
\title{Summarize the segtypeInfo list}
\usage{
segtypeInfoSummary(segtypeInfo)
}
\arguments{
\item{segtypeInfo}{a list as returned by calcSegtypeInfo or selSegtypeInfo}
}
\value{
A data frame summarizing the segtypeInfo list, with columns:
\itemize{
\item{segtype: the name of the segregation type (see details of
calcSegtypeInfo)}
\item{segtypenr: the sequential number of the segtype in parameter segtypeInfo}
\item{parent1, parent2: dosages of the two parents}
\item{par.poly, par.di, par.mixed: whether these parental dosages produce this
segtype under polysomic, disomic and/or mixed inheritance}
}
}
\description{
From a list of segregation types as produced by calcSegtypeInfo
or selSegtypeInfo, produce a data frame that only lists the parental
dosage combinations for each segtype and whether these produce the
segtype under polysomic, disomic and/or mixed inheritance.
Useful to quickly look up which segtypes match a given parental dosage
combination.
}
