% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rZIzeta.R
\name{rZIzeta}
\alias{rZIzeta}
\alias{rzizeta}
\title{Generate zero inflated zeta random variates}
\usage{
rZIzeta(n, pi = 0.5, shape = 1, offset = 0)

rzizeta(n, pi = 0.5, shape = 1, offset = 0)

rzizeta(n, pi = 0.5, shape = 1, offset = 0)
}
\arguments{
\item{n}{the number of observations.}

\item{pi}{the mixing parameter for the zero-inflated zeta model---must be in
(0, 1).}

\item{shape}{the shape parameter for the zero-inflated zeta. Must be greater
than zero.}

\item{offset}{the zeta distribution returns random variates that are greater
than, or equal to one. If the offset is greater than 0, then the
distribution is anchored on (has minimum value of) \code{1 - offset}.}
}
\value{
a vector of random variates from a zero-inflated zeta model
}
\description{
Generate zero inflated zeta random variates
}
\details{
Technically this function returns values from the one-inflated zeta
  distribution. However, if \code{offset} is greater than zero (and typically
  we expect it to be 1), then the minimium random variate value is \code{1 -
  offset}. We chose the name "zero-inflated zeta" as more people are familiar
  with zero-inflated models.
}
\examples{
data(Psurveys)
roux = Psurveys$roux
fit.zi = fitZIDist(roux)
x = rZIzeta(n = sum(roux$data$rn), pi = fit.zi$pi, shape = fit.zi$shape)
table(x)
}
