% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-core.R
\name{Firebase}
\alias{Firebase}
\title{Firebase}
\value{
An object of class \code{Firebase}.
}
\description{
Core Firebase class.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{session}}{A valid Shiny session.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Firebase-new}{\code{Firebase$new()}}
\item \href{#method-Firebase-expose_app}{\code{Firebase$expose_app()}}
\item \href{#method-Firebase-print}{\code{Firebase$print()}}
\item \href{#method-Firebase-clone}{\code{Firebase$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Firebase-new"></a>}}
\if{latex}{\out{\hypertarget{method-Firebase-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Firebase$new(
  config_path = "firebase.rds",
  session = shiny::getDefaultReactiveDomain()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{config_path}}{Path to the configuration file as created by \code{\link{firebase_config}}.}

\item{\code{session}}{A valid shiny session.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Initialise Firebase

Initialises the Firebase application client-side.
}

\subsection{Returns}{
Invisibly return the class.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Firebase-expose_app"></a>}}
\if{latex}{\out{\hypertarget{method-Firebase-expose_app}{}}}
\subsection{Method \code{expose_app()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Firebase$expose_app()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Expose App

Expose the \code{firebaseApp} object product of \code{initializeApp()} by
attaching it to the \code{window}: access it with \code{window.firebaseApp}.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Firebase-print"></a>}}
\if{latex}{\out{\hypertarget{method-Firebase-print}{}}}
\subsection{Method \code{print()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Firebase$print()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Print the class
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Firebase-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Firebase-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Firebase$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
