% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finnishgrid.R
\name{powersys_kinetic_energy_nordic_pwr_sys_RTD}
\alias{powersys_kinetic_energy_nordic_pwr_sys_RTD}
\title{Kinetic energy of the Nordic power system - real time data}
\usage{
powersys_kinetic_energy_nordic_pwr_sys_RTD(
  start_time_utc = NA,
  end_time_utc = NA,
  user_key = NA
)
}
\arguments{
\item{start_time_utc}{Start time in UTC. Character array YYYY-MM-ddTHH:mm:ss.sssZ}

\item{end_time_utc}{End time in UTC. Character array YYYY-MM-ddTHH:mm:ss.sssZ}

\item{user_key}{Character array holding API-key.
Free from https://data.fingrid.fi/en/instructions}
}
\value{
A data frame object with time series data having period 1 min and unit type 1 GWs.
}
\description{
Real-time estimate of the kinetic energy of the Nordic power system calculated by the Nordic transmission system operators. The data is updated every 1 minute. Historical data as of 27.3.2015 available.
}
\examples{
\dontrun{
library(finnishgrid)
start = "2024-06-01T00:00:00.000Z"  # UTC
end = "2024-06-03T00:00:00.000Z"    # UTC
key = "MY_SUPER_SECRET"
df <- powersys_kinetic_energy_nordic_pwr_sys_RTD(start_time_utc = start,
         end_time_utc = end,
         user_key = key)
summary(df)
}
}
\seealso{
https://data.fingrid.fi/en/datasets/260
}
