% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finnishgrid.R
\name{imbalance_production_sales_price}
\alias{imbalance_production_sales_price}
\title{The sales price of production imbalance electricity}
\usage{
imbalance_production_sales_price(
  start_time_utc = NA,
  end_time_utc = NA,
  user_key = NA
)
}
\arguments{
\item{start_time_utc}{Start time in UTC. Character array YYYY-MM-ddTHH:mm:ss.sssZ}

\item{end_time_utc}{End time in UTC. Character array YYYY-MM-ddTHH:mm:ss.sssZ}

\item{user_key}{Character array holding API-key.
Free from https://data.fingrid.fi/en/instructions}
}
\value{
A data frame object with time series data having period 1 h and unit type EUR/MWh.
}
\description{
The up-regulating price of the hour is the price of production imbalance power sold by Fingrid to a balance responsible party. If no up regulation has been made or if the hour has been defined as a down-regulation hour, the day ahead spot price of Finland is used as the selling price of production imbalance power. Separate production balance ended when 1.11.2021 01.00 settlement model was changed to single imbalance.
}
\examples{
\dontrun{
library(finnishgrid)
start = "2024-06-01T00:00:00.000Z"  # UTC
end = "2024-06-03T00:00:00.000Z"    # UTC
key = "MY_SUPER_SECRET"
df <- imbalance_production_sales_price(start_time_utc = start,
         end_time_utc = end,
         user_key = key)
summary(df)
}
}
\seealso{
https://data.fingrid.fi/en/datasets/93
}
