% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findviews_to_predict.R
\name{findviews_to_predict}
\alias{findviews_to_predict}
\title{Views of a multidimensional dataset, ranked by their prediction power.}
\usage{
findviews_to_predict(target, data, view_size_max = NULL,
  clust_method = "complete", ...)
}
\arguments{
\item{target}{Name of the variable to be predicted.}

\item{data}{Data frame or matrix to be processed}

\item{view_size_max}{Maximum number of columns in the views. If set to
\code{NULL}, findviews uses \code{log2(ncol(data))}, rounded upwards and
capped at 5.}

\item{clust_method}{Character describing a clustering method, used internally
by \code{\link[stats]{hclust}}. Example values are "complete", "single" or
"average".}

\item{...}{Optional Shiny parameters, used in Shiny's
\code{\link[shiny]{runApp}} function.}
}
\description{
\code{findviews_to_predict} detects groups of mutually dependent columns,
ranks them by predictive power, and plots them with Shiny and ggplot.
}
\details{
The function \code{findviews_to_predict} takes a data set and a target
variable as input. It detects clusters of statistically dependent columns in
the data set - e.g., views - and ranks those groups according to how well
they predict the target variable.

To detect the views, \code{findviews_to_predict} relies on \code{findviews}.
To evaluate their predictive power, it uses the \emph{mutual information}
between the joint distribution of the columns and that of the target
variable. Internally, \code{findviews_to_predict} discretizes all the
continuous variables with equi-width binning.

Note: \code{findviews_to_predict} removes the column to be predicted (the
target column) from the dataset before it creates the column groups. Hence,
the views it returns may be different from those return by calling by
\code{findviews} directly on the dataset.
}
\examples{
\dontrun{
findviews_to_predict('mpg', mtcars)
findviews_to_predict('mpg', mtcars, view_size_max = 4)
}

}

