#' @description
#' With the functions `figi_check`, `cusip_check`, `isin_check`,
#' `sedol_check`, in this package, you can check the
#' validity of the following financial instrument identifiers:
#' FIGI (Financial Instrument Global Identifier
#' <https://www.openfigi.com/about/figi>),
#' CUSIP (Committee on Uniform Security Identification Procedures
#' <https://www.cusip.com/identifiers.html#/CUSIP>),
#' ISIN (International Securities Identification Number
#' <https://www.cusip.com/identifiers.html#/ISIN>),
#' SEDOL (Stock Exchange Daily Official List
#' <https://www2.lseg.com/SEDOL-masterfile-service-tech-guide-v8.6>).
#' With the function `figi_compute_checksum`,
#' you can also calculate the FIGI checksum of 11-character strings,
#' which can be useful if you want to create your own FIGI identifiers.
#' @keywords internal
"_PACKAGE"

## usethis namespace: start
## usethis namespace: end
NULL
